/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SetSentryMode
implements IMessage {
    private List<Info> sentriesToUpdate;

    public SetSentryMode() {
    }

    public SetSentryMode(List<Info> sentriesToUpdate) {
        sentriesToUpdate.removeIf(Objects::isNull);
        this.sentriesToUpdate = sentriesToUpdate;
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        this.sentriesToUpdate = new ArrayList<Info>();
        for (int i = 0; i < size; ++i) {
            this.sentriesToUpdate.add(Info.read(buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.sentriesToUpdate.size());
        this.sentriesToUpdate.forEach(info -> info.write(buf));
    }

    public static class Info {
        private final BlockPos pos;
        private final int mode;

        public Info(BlockPos pos, int mode) {
            this.pos = pos;
            this.mode = mode;
        }

        public static Info read(ByteBuf buf) {
            return new Info(BlockPos.func_177969_a((long)buf.readLong()), buf.readInt());
        }

        public void write(ByteBuf buf) {
            buf.writeLong(this.pos.func_177986_g());
            buf.writeInt(this.mode);
        }
    }

    public static class Handler
    implements IMessageHandler<SetSentryMode, IMessage> {
        public IMessage onMessage(SetSentryMode message, MessageContext context) {
            Utils.addScheduledTask(context.getServerHandler().field_147369_b.field_70170_p, () -> {
                EntityPlayerMP player = context.getServerHandler().field_147369_b;
                World level = player.field_70170_p;
                if (!player.func_175149_v()) {
                    for (Info info : message.sentriesToUpdate) {
                        List sentries;
                        if (!level.func_175667_e(info.pos) || (sentries = level.func_72872_a(Sentry.class, new AxisAlignedBB(info.pos))).isEmpty() || !((Sentry)sentries.get(0)).isOwnedBy((Entity)player)) continue;
                        ((Sentry)sentries.get(0)).toggleMode((EntityPlayer)player, info.mode, false);
                    }
                }
            });
            return null;
        }
    }
}

